<?php
header('Content-Type: application/json');

function erro($msg) {
    echo json_encode(['error' => $msg]);
    exit;
}

$m3u = trim($_POST['playlist_url'] ?? '');
$server = trim($_POST['xtream_server'] ?? '');
$user = trim($_POST['xtream_user'] ?? '');
$pass = trim($_POST['xtream_pass'] ?? '');

/* SE VEIO M3U */
if ($m3u && (!$user || !$pass)) {
    parse_str(parse_url($m3u, PHP_URL_QUERY), $q);

    if (!isset($q['username'], $q['password'])) {
        erro('URL M3U inválida.');
    }

    $user = $q['username'];
    $pass = $q['password'];
    $server = preg_replace('#/get\.php.*#', '', $m3u);
}

if (!$server || !$user || !$pass) {
    erro('Informe M3U ou Xtream Codes completos.');
}

/* API XTREAM */
$api = rtrim($server, '/') . "/player_api.php?username={$user}&password={$pass}";

$ch = curl_init($api);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false
]);

$response = curl_exec($ch);
curl_close($ch);

if (!$response) {
    erro('Servidor não respondeu.');
}

$data = json_decode($response, true);
if (!isset($data['user_info'])) {
    erro('Conta inválida ou bloqueada.');
}

$u = $data['user_info'];

/* M3U HLS */
$m3u_hls = rtrim($server, '/') .
    "/get.php?username={$user}&password={$pass}&type=m3u_plus&output=hls";

echo json_encode([
    'details' => [
        'Status' => strtoupper($u['status']),
        'Usuário' => $user,
        'Senha' => $pass,
        'Servidor' => $server,
        'Link M3U (HLS)' => $m3u_hls,
        'Expira em' => $u['exp_date'] ? date('d/m/Y H:i', $u['exp_date']) : 'Nunca',
        'Trial' => $u['is_trial'] ? 'Sim' : 'Não',
        'Conexões Ativas' => $u['active_cons'],
        'Máx. Conexões' => $u['max_connections'],
        'Criado em' => date('d/m/Y', $u['created_at'])
    ]
]);
